﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Data;

namespace WPF.PresentationLayer.Converters
{
    public class BoolToVisibilityConverter : IValueConverter
    {
        public Visibility TrueValueVisibility { get; set; }
        public Visibility FalseValueVisibility { get; set; }

        public BoolToVisibilityConverter()
        {
            TrueValueVisibility = Visibility.Visible;
            FalseValueVisibility = Visibility.Collapsed;
        }

        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            if (value == null)
            {
                return FalseValueVisibility;
            }

            if ((bool)value == true)
            {
                return TrueValueVisibility;
            }
            else
            {
                return FalseValueVisibility;
            }
        }

        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
